




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security.authentication;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.management.utils.AlreadyExistsException;
import weblogic.management.utils.InvalidParameterException;
import weblogic.management.utils.NotFoundException;


/**
 * Corresponds to UserEditorMBean
 * (Interface=weblogic.management.security.authentication.UserEditorMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * <p>Provides a set of methods for creating, editing, and removing users.
 An Authentication provider MBean can optionally implement this MBean. The WebLogic
 Server Administration Console detects when an Authentication provider implements this
 MBean and automatically provides a GUI for using these methods.</p>

 <p>CSS v4 introduced a new Password Validaton Service to check password against a set of rules when doing
 changing password operations with authentication provider MBeans such as <code>createUser</code>, <code>changeUserPassword</code>
 and <code>resetUserPassword</code>. The rules can be specified through configuring Password Validation Provider into the
 security realm, for further information, see <code>weblogic.management.security.RealmMBean</code>.</p>

 <p>All OOTB authentication providers in CSS will automatically call the Password Validation Service if their MBeans inherit
 <code>UserPasswordEditorMBean</code> interface. The service is also available for all those customized authentication
 providers whose MBeans inherit <code>UserPasswordEditorMBean</code>, to introduce the Password Validation Service into a
 customized authentication proivder, the following approach must be met:</p>
 
 <ol>
 <li>
 <p>In the <code>initialize</code> method of a customized provider implementation, must retrieve the Password Validation
 Service and register the service into a helper class such as <code>weblogic.security.provider.authentication.AuthenticationSecurityHelper</code>,
 the code might like as below:</p>
 
 <p><code>
 import com.bea.common.security.service.PasswordValidationService;<br>
 import com.bea.common.security.legacy.ExtendedSecurityServices;<br>
 import com.bea.common.security.internal.legacy.helper.PasswordValidationServiceConfigHelper;<br>
 import weblogic.security.provider.authentication.AuthenticationSecurityHelper;<br>
 ......<br>
 ExtendedSecurityServices extendedSecurityServices = (ExtendedSecurityServices)securityServices;<br>
 PasswordValidationService serivce = (PasswordValidationService)extendedSecurityServices.getServices().getService(PasswordValidationServiceConfigHelper.getServiceName(providerMBean.getRealm()));<br>
 AuthenticationSecurityHelper.getInstance(providerMBean).registerPasswordValidationService(service);<br>
 ......</code></p>
 </li>
 <li>
 <p>In the <code>createUser</code>, <code>changeUserPassword</code> and(or) <code>resetUserPassword</code> methods of a customized authentication
 provider MBean, call the helper class to validate the new password to determine if the new password is valid. The code might be:</p>
 
 <p><code>
 import weblogic.security.provider.authentication.AuthenticationSecurityHelper;<br>
 .....<br>
 AuthenticationSecurityHelper.getInstance(providerMBean).validatePassword(userName,password);<br>
 .....</code></p>
 </li>
 </ol>
 *
 * @xsdgen:complexType.typeName user-editorType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 */
public class UserEditorMBeanImpl
  extends UserReaderMBeanImpl
  implements UserEditorMBean, java.io.Serializable
{


  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=UserEditorMBeanImpl)
   *
   */
  public UserEditorMBeanImpl() {
    super();
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=UserEditorMBeanImpl)
   *
   */
  public UserEditorMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=UserEditorMBeanImpl)
   *
   */
  public UserEditorMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    _initializeProperty(-1);
  }

  /**
   * Used by a user to change his or her password.
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=changeUserPassword)
   *
   */
  public void changeUserPassword(String param0, String param1, String param2)
    throws NotFoundException, InvalidParameterException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * Creates a user and sets the user's password.
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=createUser)
   *
   */
  public void createUser(String param0, String param1, String param2)
    throws InvalidParameterException, AlreadyExistsException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * Removes a user.
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=removeUser)
   *
   */
  public void removeUser(String param0)
    throws NotFoundException, InvalidParameterException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * Used by an administrator to change a user's password.
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=resetUserPassword)
   *
   */
  public void resetUserPassword(String param0, String param1)
    throws NotFoundException, InvalidParameterException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * Sets the description for an existing user.
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=setUserDescription)
   *
   */
  public void setUserDescription(String param0, String param1)
    throws NotFoundException, InvalidParameterException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserEditorMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = -1;
    }
    try {
      switch (idx) {
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends UserReaderMBeanImpl.Helper
  {
    private UserEditorMBeanImpl bean;

    protected Helper(UserEditorMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      UserEditorMBeanImpl otherTyped = (UserEditorMBeanImpl)other;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        UserEditorMBeanImpl original = (UserEditorMBeanImpl)event.getSourceBean();
        UserEditorMBeanImpl proposed = (UserEditorMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        UserEditorMBeanImpl copy = (UserEditorMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
     }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends UserReaderMBeanImpl.SchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        default: return super.getElementName(propIndex);
      }
    }
















  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.authentication.UserEditorMBean"; 
  }

}
