




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security.pk;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.management.security.ProviderMBean;
import javax.management.InvalidAttributeValueException;


/**
 * Corresponds to KeyStoreMBean
 * (Interface=weblogic.management.security.pk.KeyStoreMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * The SSPI MBean that all Keystore providers must extend.  It was deprecated in WLS 8.1.
 *
 * @xsdgen:complexType.typeName key-storeType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 */
public class KeyStoreMBeanImpl
  extends weblogic.management.security.ProviderMBeanImpl
  implements KeyStoreMBean, java.io.Serializable
{
  private String _PrivateKeyStoreLocation;
  private String _PrivateKeyStorePassPhrase;
  private byte[] _PrivateKeyStorePassPhraseEncrypted;
  private String _RootCAKeyStoreLocation;
  private String _RootCAKeyStorePassPhrase;
  private byte[] _RootCAKeyStorePassPhraseEncrypted;
  private String _Type;


  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=KeyStoreMBeanImpl)
   *
   */
  public KeyStoreMBeanImpl() {
    super();
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=KeyStoreMBeanImpl)
   *
   */
  public KeyStoreMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=KeyStoreMBeanImpl)
   *
   */
  public KeyStoreMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    _initializeProperty(-1);
  }

  /**
   * Returns the passphrase used to access the keystore specified by the <code>PrivateKeyStoreLocation</code> attribute.
 If the passphase is null, no passphrase will be used to access the keystore.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getPrivateKeyStorePassPhrase)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String getPrivateKeyStorePassPhrase() {
    byte[] bEncrypted = getPrivateKeyStorePassPhraseEncrypted();
    return (bEncrypted == null) ? null : _decrypt("PrivateKeyStorePassPhrase", bEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isPrivateKeyStorePassPhraseInherited)
   *
   * return true if the value of property PrivateKeyStorePassPhrase is inherited from template
   */
  public boolean isPrivateKeyStorePassPhraseInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isPrivateKeyStorePassPhraseSet)
   *
   * @xsdgen:isSetMethodFor private-key-store-pass-phrase
   */
  public boolean isPrivateKeyStorePassPhraseSet() {
    return isPrivateKeyStorePassPhraseEncryptedSet();
  }

  /**
   * Sets the passphrase used to access the keystore specified by the <code>PrivateKeyStoreLocation</code> attribute.
 Set the passphrase to null if no passphrase is needed to access the keystore.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setPrivateKeyStorePassPhrase)
   *
   */
  public void setPrivateKeyStorePassPhrase(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    setPrivateKeyStorePassPhraseEncrypted(param0 == null ? null : _encrypt("PrivateKeyStorePassPhrase", param0));
  }

  /**
   * Returns the passphrase used to access the keystore specified by the <code>PrivateKeyStoreLocation</code> attribute.
 If the passphase is null, no passphrase will be used to access the keystore.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getPrivateKeyStorePassPhraseEncrypted)
   *
   * @xsdgen:element.exclude
   */
  public byte[] getPrivateKeyStorePassPhraseEncrypted() {
    return _getHelper()._cloneArray(_PrivateKeyStorePassPhraseEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getPrivateKeyStorePassPhraseEncryptedAsString)
   *
   * @xsdgen:element.name private-key-store-pass-phrase-encrypted
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   */
  public String getPrivateKeyStorePassPhraseEncryptedAsString() {
    byte[] obj = getPrivateKeyStorePassPhraseEncrypted();
    return (obj == null) ? null : (new String(obj));
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isPrivateKeyStorePassPhraseEncryptedInherited)
   *
   * return true if the value of property PrivateKeyStorePassPhraseEncrypted is inherited from template
   */
  public boolean isPrivateKeyStorePassPhraseEncryptedInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isPrivateKeyStorePassPhraseEncryptedSet)
   *
   * @xsdgen:isSetMethodFor private-key-store-pass-phrase-encrypted
   */
  public boolean isPrivateKeyStorePassPhraseEncryptedSet() {
    return _isSet(9);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setPrivateKeyStorePassPhraseEncryptedAsString)
   *
   */
  public void setPrivateKeyStorePassPhraseEncryptedAsString(String param0) {
    try {
    byte[] encryptedBytes = (param0 == null) ? null : param0.getBytes();
    setPrivateKeyStorePassPhraseEncrypted(encryptedBytes);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Returns the passphrase used to access the keystore specified by the <code>RootCAKeyStoreLocation</code> attribute.
 If the passphase is null, no passphrase will be used to access the keystore.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getRootCAKeyStorePassPhrase)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String getRootCAKeyStorePassPhrase() {
    byte[] bEncrypted = getRootCAKeyStorePassPhraseEncrypted();
    return (bEncrypted == null) ? null : _decrypt("RootCAKeyStorePassPhrase", bEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isRootCAKeyStorePassPhraseInherited)
   *
   * return true if the value of property RootCAKeyStorePassPhrase is inherited from template
   */
  public boolean isRootCAKeyStorePassPhraseInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isRootCAKeyStorePassPhraseSet)
   *
   * @xsdgen:isSetMethodFor root-ca-key-store-pass-phrase
   */
  public boolean isRootCAKeyStorePassPhraseSet() {
    return isRootCAKeyStorePassPhraseEncryptedSet();
  }

  /**
   * Sets the passphrase used to access the keystore specified by the <code>RootCAKeyStoreLocation</code> attribute.
 Set the passphrase to null if no passphrase is needed to access the keystore.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setRootCAKeyStorePassPhrase)
   *
   */
  public void setRootCAKeyStorePassPhrase(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    setRootCAKeyStorePassPhraseEncrypted(param0 == null ? null : _encrypt("RootCAKeyStorePassPhrase", param0));
  }

  /**
   * Returns the passphrase used to access the keystore specified by the <code>RootCAKeyStoreLocation</code> attribute.
 If the passphase is null, no passphrase will be used to access the keystore.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getRootCAKeyStorePassPhraseEncrypted)
   *
   * @xsdgen:element.exclude
   */
  public byte[] getRootCAKeyStorePassPhraseEncrypted() {
    return _getHelper()._cloneArray(_RootCAKeyStorePassPhraseEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getRootCAKeyStorePassPhraseEncryptedAsString)
   *
   * @xsdgen:element.name root-ca-key-store-pass-phrase-encrypted
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   */
  public String getRootCAKeyStorePassPhraseEncryptedAsString() {
    byte[] obj = getRootCAKeyStorePassPhraseEncrypted();
    return (obj == null) ? null : (new String(obj));
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isRootCAKeyStorePassPhraseEncryptedInherited)
   *
   * return true if the value of property RootCAKeyStorePassPhraseEncrypted is inherited from template
   */
  public boolean isRootCAKeyStorePassPhraseEncryptedInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isRootCAKeyStorePassPhraseEncryptedSet)
   *
   * @xsdgen:isSetMethodFor root-ca-key-store-pass-phrase-encrypted
   */
  public boolean isRootCAKeyStorePassPhraseEncryptedSet() {
    return _isSet(11);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setRootCAKeyStorePassPhraseEncryptedAsString)
   *
   */
  public void setRootCAKeyStorePassPhraseEncryptedAsString(String param0) {
    try {
    byte[] encryptedBytes = (param0 == null) ? null : param0.getBytes();
    setRootCAKeyStorePassPhraseEncrypted(encryptedBytes);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Returns the location of the keystore used to store identities - that is, certificate and private key pairs.
 <p>
 The configured Keystore provider implementation determines the requirements for this attribute.
 For more information about legal values, refer to the documentation supplied by the Keystore security vendor.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getPrivateKeyStoreLocation)
   *
   * @xsdgen:element.name private-key-store-location
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getPrivateKeyStoreLocation() {
    return _PrivateKeyStoreLocation;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isPrivateKeyStoreLocationInherited)
   *
   * return true if the value of property PrivateKeyStoreLocation is inherited from template
   */
  public boolean isPrivateKeyStoreLocationInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isPrivateKeyStoreLocationSet)
   *
   * @xsdgen:isSetMethodFor private-key-store-location
   */
  public boolean isPrivateKeyStoreLocationSet() {
    return _isSet(12);
  }

  /**
   * Sets the location of the keystore used to store identities - that is, certificate and private key pairs.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setPrivateKeyStoreLocation)
   *
   */
  public void setPrivateKeyStoreLocation(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _PrivateKeyStoreLocation;
    _PrivateKeyStoreLocation = param0;
    _postSet(12, _oldVal, param0);
  }

  /**
   * Returns the location of the keystore used to store trusted certificate authority certificates.
 <p>
 The configured Keystore provider implementation determines the requirements for this attribute.
 For more information about legal values, refer to the documentation supplied by the Keystore security vendor.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getRootCAKeyStoreLocation)
   *
   * @xsdgen:element.name root-ca-key-store-location
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getRootCAKeyStoreLocation() {
    return _RootCAKeyStoreLocation;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isRootCAKeyStoreLocationInherited)
   *
   * return true if the value of property RootCAKeyStoreLocation is inherited from template
   */
  public boolean isRootCAKeyStoreLocationInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isRootCAKeyStoreLocationSet)
   *
   * @xsdgen:isSetMethodFor root-ca-key-store-location
   */
  public boolean isRootCAKeyStoreLocationSet() {
    return _isSet(13);
  }

  /**
   * Sets the location of the keystore used to store trusted certificate authority certificates.
 For more information about legal values, refer to the documentation supplied by the Keystore security vendor.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setRootCAKeyStoreLocation)
   *
   */
  public void setRootCAKeyStoreLocation(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _RootCAKeyStoreLocation;
    _RootCAKeyStoreLocation = param0;
    _postSet(13, _oldVal, param0);
  }

  /**
   * Returns the type of the Keystore implementation that this provider supports,
 as defined by the JavaSoft Cryptography Architecture specification.
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=getType)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String getType() {
    return _Type;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isTypeInherited)
   *
   * return true if the value of property Type is inherited from template
   */
  public boolean isTypeInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=isTypeSet)
   *
   * @xsdgen:isSetMethodFor type
   */
  public boolean isTypeSet() {
    return _isSet(14);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setType)
   *
   */
  public void setType(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    _Type = param0;
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setPrivateKeyStorePassPhraseEncrypted)
   *
   */
  public void setPrivateKeyStorePassPhraseEncrypted(byte[] param0) {
    byte[] _oldVal = _PrivateKeyStorePassPhraseEncrypted;
    if(_isProductionModeEnabled()) {
      if(param0 != null && !_isEncrypted(param0)) {
        throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PrivateKeyStorePassPhraseEncrypted of KeyStoreMBean");
      }
    }
    _getHelper()._clearArray(_PrivateKeyStorePassPhraseEncrypted);
    _PrivateKeyStorePassPhraseEncrypted = _getHelper()._cloneArray(param0);
    _postSet(9, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.pk.KeyStoreMBean Attribute=setRootCAKeyStorePassPhraseEncrypted)
   *
   */
  public void setRootCAKeyStorePassPhraseEncrypted(byte[] param0) {
    byte[] _oldVal = _RootCAKeyStorePassPhraseEncrypted;
    if(_isProductionModeEnabled()) {
      if(param0 != null && !_isEncrypted(param0)) {
        throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: RootCAKeyStorePassPhraseEncrypted of KeyStoreMBean");
      }
    }
    _getHelper()._clearArray(_RootCAKeyStorePassPhraseEncrypted);
    _RootCAKeyStorePassPhraseEncrypted = _getHelper()._cloneArray(param0);
    _postSet(11, _oldVal, param0);
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
      if (idx == 8) _markSet(9, false);
      if (idx == 10) _markSet(11, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 12;
    }
    try {
      switch (idx) {
      case 12:
        _PrivateKeyStoreLocation = null;
        if (initOne) break;
      case 8:
        _PrivateKeyStorePassPhraseEncrypted = null;
        if (initOne) break;
      case 9:
        _PrivateKeyStorePassPhraseEncrypted = null;
        if (initOne) break;
      case 13:
        _RootCAKeyStoreLocation = null;
        if (initOne) break;
      case 10:
        _RootCAKeyStorePassPhraseEncrypted = null;
        if (initOne) break;
      case 11:
        _RootCAKeyStorePassPhraseEncrypted = null;
        if (initOne) break;
      case 14:
        _Type = "jks";
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.security.ProviderMBeanImpl.Helper
  {
    private KeyStoreMBeanImpl bean;

    protected Helper(KeyStoreMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 12: return "PrivateKeyStoreLocation";
      case 8: return "PrivateKeyStorePassPhrase";
      case 9: return "PrivateKeyStorePassPhraseEncrypted";
      case 13: return "RootCAKeyStoreLocation";
      case 10: return "RootCAKeyStorePassPhrase";
      case 11: return "RootCAKeyStorePassPhraseEncrypted";
      case 14: return "Type";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("PrivateKeyStoreLocation")) return 12;
      else if (propName.equals("PrivateKeyStorePassPhrase")) return 8;
      else if (propName.equals("PrivateKeyStorePassPhraseEncrypted")) return 9;
      else if (propName.equals("RootCAKeyStoreLocation")) return 13;
      else if (propName.equals("RootCAKeyStorePassPhrase")) return 10;
      else if (propName.equals("RootCAKeyStorePassPhraseEncrypted")) return 11;
      else if (propName.equals("Type")) return 14;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isPrivateKeyStoreLocationSet()){
          buf.append("PrivateKeyStoreLocation");
          buf.append(String.valueOf(bean.getPrivateKeyStoreLocation()));
        }
        if (bean.isPrivateKeyStorePassPhraseSet()){
          buf.append("PrivateKeyStorePassPhrase");
          buf.append(String.valueOf(bean.getPrivateKeyStorePassPhrase()));
        }
        if (bean.isPrivateKeyStorePassPhraseEncryptedSet()){
          buf.append("PrivateKeyStorePassPhraseEncrypted");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getPrivateKeyStorePassPhraseEncrypted())));
        }
        if (bean.isRootCAKeyStoreLocationSet()){
          buf.append("RootCAKeyStoreLocation");
          buf.append(String.valueOf(bean.getRootCAKeyStoreLocation()));
        }
        if (bean.isRootCAKeyStorePassPhraseSet()){
          buf.append("RootCAKeyStorePassPhrase");
          buf.append(String.valueOf(bean.getRootCAKeyStorePassPhrase()));
        }
        if (bean.isRootCAKeyStorePassPhraseEncryptedSet()){
          buf.append("RootCAKeyStorePassPhraseEncrypted");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getRootCAKeyStorePassPhraseEncrypted())));
        }
        if (bean.isTypeSet()){
          buf.append("Type");
          buf.append(String.valueOf(bean.getType()));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      KeyStoreMBeanImpl otherTyped = (KeyStoreMBeanImpl)other;
      computeDiff("PrivateKeyStoreLocation", bean.getPrivateKeyStoreLocation(), otherTyped.getPrivateKeyStoreLocation(), false);
      computeDiff("PrivateKeyStorePassPhraseEncrypted", bean.getPrivateKeyStorePassPhraseEncrypted(), otherTyped.getPrivateKeyStorePassPhraseEncrypted(), false);
      computeDiff("RootCAKeyStoreLocation", bean.getRootCAKeyStoreLocation(), otherTyped.getRootCAKeyStoreLocation(), false);
      computeDiff("RootCAKeyStorePassPhraseEncrypted", bean.getRootCAKeyStorePassPhraseEncrypted(), otherTyped.getRootCAKeyStorePassPhraseEncrypted(), false);
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        KeyStoreMBeanImpl original = (KeyStoreMBeanImpl)event.getSourceBean();
        KeyStoreMBeanImpl proposed = (KeyStoreMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("PrivateKeyStoreLocation")) {
          original.setPrivateKeyStoreLocation(proposed.getPrivateKeyStoreLocation());
          original._conditionalUnset(update.isUnsetUpdate(), 12);
        } else
        if (prop.equals("PrivateKeyStorePassPhrase")) {
        } else
        if (prop.equals("PrivateKeyStorePassPhraseEncrypted")) {
          original.setPrivateKeyStorePassPhraseEncrypted(proposed.getPrivateKeyStorePassPhraseEncrypted());
          original._conditionalUnset(update.isUnsetUpdate(), 9);
        } else
        if (prop.equals("RootCAKeyStoreLocation")) {
          original.setRootCAKeyStoreLocation(proposed.getRootCAKeyStoreLocation());
          original._conditionalUnset(update.isUnsetUpdate(), 13);
        } else
        if (prop.equals("RootCAKeyStorePassPhrase")) {
        } else
        if (prop.equals("RootCAKeyStorePassPhraseEncrypted")) {
          original.setRootCAKeyStorePassPhraseEncrypted(proposed.getRootCAKeyStorePassPhraseEncrypted());
          original._conditionalUnset(update.isUnsetUpdate(), 11);
        } else
        if (prop.equals("Type")) {
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        KeyStoreMBeanImpl copy = (KeyStoreMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        if ((excludeProps == null || !excludeProps.contains("PrivateKeyStoreLocation")) && bean.isPrivateKeyStoreLocationSet()) {
          copy.setPrivateKeyStoreLocation((String)bean.getPrivateKeyStoreLocation());
        }
        if ((excludeProps == null || !excludeProps.contains("PrivateKeyStorePassPhraseEncrypted")) && bean.isPrivateKeyStorePassPhraseEncryptedSet()) {
          o = bean.getPrivateKeyStorePassPhraseEncrypted();
          copy.setPrivateKeyStorePassPhraseEncrypted((o == null) ? null : (byte[])((byte[])o).clone());
        }
        if ((excludeProps == null || !excludeProps.contains("RootCAKeyStoreLocation")) && bean.isRootCAKeyStoreLocationSet()) {
          copy.setRootCAKeyStoreLocation((String)bean.getRootCAKeyStoreLocation());
        }
        if ((excludeProps == null || !excludeProps.contains("RootCAKeyStorePassPhraseEncrypted")) && bean.isRootCAKeyStorePassPhraseEncryptedSet()) {
          o = bean.getRootCAKeyStorePassPhraseEncrypted();
          copy.setRootCAKeyStorePassPhraseEncrypted((o == null) ? null : (byte[])((byte[])o).clone());
        }
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
                          }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 26:
        if (false) return -1;
        else if (s.equals("private-key-store-location"))
          return 12;
        break;
      case 29:
        if (false) return -1;
        else if (s.equals("private-key-store-pass-phrase"))
          return 8;
        break;
      case 39:
        if (false) return -1;
        else if (s.equals("private-key-store-pass-phrase-encrypted"))
          return 9;
        break;
      case 25:
        if (false) return -1;
        else if (s.equals("rootca-key-store-location"))
          return 13;
        break;
      case 28:
        if (false) return -1;
        else if (s.equals("rootca-key-store-pass-phrase"))
          return 10;
        break;
      case 38:
        if (false) return -1;
        else if (s.equals("rootca-key-store-pass-phrase-encrypted"))
          return 11;
        break;
      case 4:
        if (false) return -1;
        else if (s.equals("type"))
          return 14;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 12: return "private-key-store-location";
        case 8: return "private-key-store-pass-phrase";
        case 9: return "private-key-store-pass-phrase-encrypted";
        case 13: return "rootca-key-store-location";
        case 10: return "rootca-key-store-pass-phrase";
        case 11: return "rootca-key-store-pass-phrase-encrypted";
        case 14: return "type";
        default: return super.getElementName(propIndex);
      }
    }


    public boolean isArray(int propIndex) {
      switch(propIndex) {
      default:
        return super.isArray(propIndex);
      }
    }




    public boolean isBean(int propIndex) {
      switch(propIndex) {
      default:
        return super.isBean(propIndex);
      }
    }










  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.pk.KeyStoreMBean"; 
  }

}
