var accessControlBookedSlotDetails = null;
/**
 * accessControlBookedSlotDetails format
 *      accessControlBookedSlotDetails {
 *                                         currentTimelineDate : time in numeric form
 *                                         bookedSlotsMap : {
*                                                              1 : {
*                                                                  SLOTNUMBER : 1,
*                                                                  ENDTIME : Date obj in js
*                                                                  STARTTIME : Date obj in js
*                                                              },
*                                                               2 : {
*                                                                  SLOTNUMBER : 2,
*                                                                  ENDTIME : Date obj in js
*                                                                  STARTTIME : Date obj in js
*                                                              }
*                                                          }
 *                                      }
 */

///// timepicker related  methods /////
function initializeTimePicker(){
    $('#fromtime').timepicker({// NO I18N
        showPeriodLabels:false,
        onHourShow : function(hour) {
            var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
            var selectStartZeroMinsDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('startDate').value));// NO I18N
            var selectStartDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('startDate').value));// NO I18N
            var currentDate = getServerDate();
            selectStartDate.setHours(hour);
            selectStartDate.setMinutes(0);
            selectStartZeroMinsDate.setMinutes(0);
            selectStartZeroMinsDate.setHours(hour);
            var maximumRequestDay = getMaximumRequestDate();
            if(selectStartDate.getTime() > maximumRequestDay.getTime()){
                return false;
            }
            selectStartDate.setMinutes(59);
            if(selectStartDate.getTime() < currentDate.getTime()){
                //time before current time are disabled
                return false;
            }
            for (const key of Object.keys(bookedSlots)) {
                var bookedSlot = bookedSlots[key];
                if((currentDate.getTime() >= bookedSlot.STARTTIME.getTime()) && (selectStartDate.getTime() <= bookedSlot.ENDTIME.getTime())){
                    // if hour is partially a booked hour and if the free space in the past
                    return false;
                }
                if((selectStartZeroMinsDate.getTime() >= bookedSlot.STARTTIME.getTime() && selectStartDate.getTime() < bookedSlot.ENDTIME.getTime())){
                    // if total hour is under booked slot
                    return false;
                }
            }
            return true;
        },
        onMinuteShow: function(hour, minute) {
            var currentDate = getServerDate();
            var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
            var selectStartDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('startDate').value));// NO I18N
            selectStartDate.setHours(hour);
            selectStartDate.setMinutes(minute);
            if(selectStartDate.getTime() < currentDate.getTime()){
                return false;
            }
            var maximumRequestDay = getMaximumRequestDate();
            if(selectStartDate.getTime() > maximumRequestDay.getTime()){
                return false;
            }

            for (const key of Object.keys(bookedSlots)) {
                var bookedSlot = bookedSlots[key];
                if(selectStartDate.getTime() >= bookedSlot.STARTTIME.getTime() && selectStartDate.getTime() < bookedSlot.ENDTIME.getTime()){
                    return false;
                }
            }
            return true;
        }
    });
    $('#totime').timepicker({// NO I18N
        showPeriodLabels:false,
        onHourShow : function(hour) {
            var currentDate = getServerDate();
            var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
            var selectStartDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('startDate').value));// NO I18N
            var selectedStartTime = makeHourIsToMinsStringOrdered(document.getElementById('fromtime').value);// NO I18N
            selectStartDate.setHours(getHourFromTime(selectedStartTime));
            var selectEndDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('endDate').value));// NO I18N
            selectEndDate.setHours(hour);
            selectEndDate.setMinutes(59);
            if(selectEndDate.getTime() < currentDate.getTime()){
                //time before current time are disabled
                return false;
            }

            var maximumRequestDay = getMaximumRequestDate();
            selectEndDate.setMinutes(0);
            if(selectEndDate.getTime() > maximumRequestDay.getTime()){
                //time after max requesting time are disabled
                return false;
            }
            //accessDurLimit
            var maximumAccessDuration = getMaximumAccessDurationDate();
            if(selectEndDate.getTime() > maximumAccessDuration.getTime()){
                //time after max duration of access calculated from selected start times are disabled
                return false;
            }
            var nextNearestStartingBookedSlotDate = maximumRequestDay;
            for (const key of Object.keys(bookedSlots)) {
                var bookedSlot = bookedSlots[key];
                if(bookedSlot.STARTTIME.getTime() < nextNearestStartingBookedSlotDate.getTime() && selectStartDate.getTime() < bookedSlot.STARTTIME.getTime()){
                    nextNearestStartingBookedSlotDate = bookedSlot.STARTTIME;
                }
            }
            selectEndDate.setMinutes(59);
            if(selectEndDate.getTime() <= selectStartDate.getTime()){
                //time before selected start time are disabled
                return false;
            }
            selectEndDate.setMinutes(0);
            if(selectEndDate.getTime() > nextNearestStartingBookedSlotDate.getTime()){
                //time ranges between booked time slots are disabled
                // NOTE : end time can be a start time of booked slots
                return false;
            }
            return true;
        },
        onMinuteShow: function(hour, minute) {
            var currentDate = getServerDate();
            var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
            var selectStartDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('startDate').value));// NO I18N
            var selectedStartTime = makeHourIsToMinsStringOrdered(document.getElementById('fromtime').value);// NO I18N
            selectStartDate.setHours(getHourFromTime(selectedStartTime));
            selectStartDate.setMinutes(getMinsFromTime(selectedStartTime));
            var selectEndDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('endDate').value));// NO I18N
            selectEndDate.setHours(hour);
            selectEndDate.setMinutes(minute);
            selectEndDate.setSeconds(0);
            if(selectEndDate.getTime() < currentDate.getTime()){
                //time before current time are disabled
                return false;
            }
            var maximumRequestDay = getMaximumRequestDate();
            if(selectEndDate.getTime() > maximumRequestDay.getTime()){
                return false;
            }
            //accessDurLimit
            var maximumAccessDuration = getMaximumAccessDurationDate();
            if(selectEndDate.getTime() > maximumAccessDuration.getTime()){
                return false;
            }
            var nextNearestStartingBookedSlotDate = maximumRequestDay;
            for (const key of Object.keys(bookedSlots)) {
                var bookedSlot = bookedSlots[key];
                if(bookedSlot.STARTTIME.getTime() < nextNearestStartingBookedSlotDate.getTime() && selectStartDate.getTime() < bookedSlot.STARTTIME.getTime()){
                    nextNearestStartingBookedSlotDate = bookedSlot.STARTTIME;
                }
            }
            if(selectEndDate.getTime() <= selectStartDate.getTime() || selectEndDate.getTime() > nextNearestStartingBookedSlotDate.getTime()){
                return false;
            }
            return true;
        }
    });
}
function reinitializeTimePicker(){
    $('#fromtime').timepicker('destroy');// NO I18N
    $('#totime').timepicker('destroy');// NO I18N
    initializeTimePicker();
}

///// Calender related  methods /////

function initializeCalendar(){
    var currentDate = getServerDate();
    var maxRequestRange = getMaximumRequestDate();
    //start year --> current year
    //end year --> max password request limit year
    var startYear = currentDate.getFullYear();
    var endYear = maxRequestRange.getFullYear();
    Calendar.setup({ inputField     :    "startDate",     // id of the input field //NO I18N
        ifFormat       :    "%d/%m/%Y",      // format of the input field //NO I18N
        showsTime      :    false,
        button         :    "startDateImg",  // trigger for the calendar (button ID) //NO I18N
        align          :    "Bl",           // alignment (defaults to "Bl")//NO I18N
        singleClick    :    true,
        range          :[startYear,endYear],
        electric       : false,
        dateStatusFunc :    timeOutOfRangeForStartDate
    });

    Calendar.setup({ inputField     :    "endDate",     // id of the input field //NO I18N
        ifFormat       :    "%d/%m/%Y",      // format of the input field //NO I18N
        showsTime      :    false,
        button         :    "endDateImg",  // trigger for the calendar (button ID) //NO I18N
        align          :    "Bl",           // alignment (defaults to "Bl")//NO I18N
        singleClick    :    true,
        range          :[startYear,endYear],
        electric       : false,
        dateStatusFunc :    timeOutOfRangeForEndDate
    });
}
function timeOutOfRangeForStartDate(date, year, month, day, hours, minutes) {
    var reqDatePicLim = accessControlBookedSlotDetails.accessDayLimit;
    var now = getServerDate();
    var later = getServerDate();
    date = convertToTimeZone(date,accessControlBookedSlotDetails.timeZone);
    later.setDate(later.getDate() + reqDatePicLim);
    date = removeHrsMinsSecsFromDate(date);
    now = removeHrsMinsSecsFromDate(now);
    later = removeHrsMinsSecsFromDate(later);

    //if the display date is past current server date or display date is future max request limit days disable
        if (date < now || date > later) {
        return true;
    }
    var startOfDay = convertTimeToDateObject(date.getTime());
    var endOfDay = convertTimeToDateObject(date.getTime());
    startOfDay = removeHrsMinsSecsFromDate(startOfDay);
    endOfDay.setHours(23);
    endOfDay.setMinutes(59);
    endOfDay.setSeconds(59);

    var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
    for (const key of Object.keys(bookedSlots)) {
        var bookedSlot = bookedSlots[key];
        if(startOfDay.getTime() >= bookedSlot.STARTTIME.getTime() && endOfDay.getTime() <= bookedSlot.ENDTIME.getTime()){
            return true;
        }
    }
}
function timeOutOfRangeForEndDate(date, year, month, day, hours, minutes) {
    var reqDatePicLim= accessControlBookedSlotDetails.accessDayLimit;
    var now= getServerDate();
    var later= getServerDate();
    date = convertToTimeZone(date,accessControlBookedSlotDetails.timeZone);
    later.setDate(later.getDate() + reqDatePicLim);
    date = removeHrsMinsSecsFromDate(date);
    now = removeHrsMinsSecsFromDate(now);
    later = removeHrsMinsSecsFromDate(later);

    //if the display date is past current server date or display date is future max request limit days disable
    if (date < now || date > later) {
        return true;
    }
    var endDate = convertTimeToDateObject(date.getTime());
    endDate = removeHrsMinsSecsFromDate(endDate);

    var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
    var selectStartDate = parseStringToDateObj(makeDateStringOrdered(document.getElementById('startDate').value));
    var selectedStartTime = makeHourIsToMinsStringOrdered(document.getElementById('fromtime').value);
    selectStartDate.setHours(getHourFromTime(selectedStartTime));
    selectStartDate.setMinutes(getMinsFromTime(selectedStartTime));
    var maximumAccessDuration = getMaximumAccessDurationDate();
    if(endDate.getTime() > maximumAccessDuration.getTime()){
        return true;
    }
    var nextNearestStartingBookedSlotDate = getServerDate();
    nextNearestStartingBookedSlotDate.setDate(nextNearestStartingBookedSlotDate.getDate() + accessControlBookedSlotDetails.accessDayLimit);
    for (const key of Object.keys(bookedSlots)) {
        var bookedSlot = bookedSlots[key];
        if(bookedSlot.STARTTIME.getTime() < nextNearestStartingBookedSlotDate.getTime() && selectStartDate.getTime() < bookedSlot.STARTTIME.getTime()){
            nextNearestStartingBookedSlotDate = bookedSlot.STARTTIME;
        }
    }
    if(endDate.getTime() > nextNearestStartingBookedSlotDate.getTime()){
        return true;
    }
    endDate.setHours(23);
    endDate.setMinutes(59);
    endDate.setSeconds(59);
    if(endDate.getTime() < selectStartDate.getTime()){
        return true;
    }


}
function checkStatusValidity(){
    var details = accessControlBookedSlotDetails;
    if(details != null){
        var isAccess = accessControlBookedSlotDetails.ACCESS;
        var requestNowJSON = accessControlBookedSlotDetails.requestNowJSON;
        var requestLaterJSON = accessControlBookedSlotDetails.requestLaterJSON;
        var defaultAccessOption = accessControlBookedSlotDetails.defaultAccessOption;
        var requestNowInput = document.getElementById('Request_now');// NO I18N
        var requestNowContent = document.getElementById('reqtab1');// NO I18N
        var requestLaterInput = document.getElementById('Request_later');// NO I18N
        var requestLaterContent = document.getElementById('reqtab2');// NO I18N
        if(!isAccess){
            var saveButton = document.getElementById('Password_Request_Release_Button');
            if(saveButton != null){
                saveButton.disabled = true;
                saveButton.removeAttribute('onclick');// NO I18N
                saveButton.classList.remove('uni_button');// NO I18N
                saveButton.classList.add('sec_button','disableSave');// NO I18N
            }
        }
        if(!requestNowJSON.STATUS){
            var reason = requestNowJSON.STATUS_MES;
            requestNowInput.disabled = true;
            requestNowInput.onmouseout = function() {UnTip(this);};
            requestNowInput.onmouseover = function() {Tip(reason, this, 'top');};// NO I18N
            requestNowContent.className = "hide";
        }
        if(!requestLaterJSON.STATUS){
            var reason = requestLaterJSON.STATUS_MES
            requestLaterInput.disabled = true;
            requestLaterInput.onmouseout = function() {UnTip(this);};
            requestLaterInput.onmouseover = function() {Tip(reason, this, 'top');};// NO I18N
            requestLaterContent.className = "hide";// NO I18N
        }
        if(defaultAccessOption == 2 || !requestNowJSON.STATUS){
            requestLaterInput.checked = true;
        }else{
            requestNowInput.checked = true;
        }
    }
}
function setAvailableStartTime(isFirstLoad){
    var currentTime = getServerDate();
    var minstemp = (currentTime.getMinutes() % 5);
    minstemp = minstemp == 0 ? minstemp + 5 : 5 - minstemp;
    currentTime.setMinutes(currentTime.getMinutes() + minstemp);
    var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
    var isCurrentTimeAvailable = true;
    for (const key of Object.keys(bookedSlots)) {
        var bookedSlot = bookedSlots[key];
        var startTime = bookedSlot.STARTTIME;
        var endTime = bookedSlot.ENDTIME;
        if(currentTime.getTime() >= startTime.getTime() && currentTime.getTime() <= endTime.getTime()){
            isCurrentTimeAvailable = false;
            break;
        }
    }
    if(isCurrentTimeAvailable){
        var startDateString = currentTime.getDate() + "/" + (currentTime.getMonth() + 1) + "/" + currentTime.getFullYear();
        var startTimeString = currentTime.getHours() + ":" + currentTime.getMinutes();
        startDateString = makeDateStringOrdered(startDateString);
        startTimeString = makeHourIsToMinsStringOrdered(startTimeString);
        startTimeString = startTimeString.replace(/\s+/g, '');

        document.getElementById('startDate').value = startDateString;
        document.getElementById('fromtime').value = startTimeString;
        if(isFirstLoad){
            updateToDateWithFromDate();
        }
    }else {
        var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
        var bookedSlotsArray = Object.values(bookedSlots);

        // Sort slots by start time
        bookedSlotsArray.sort((a, b) => new Date(a.STARTTIME) - new Date(b.STARTTIME));

        var nextAvailableStartTime = null;

        for (var i = 0; i < bookedSlotsArray.length - 1; i++) {
            var currentSlot = bookedSlotsArray[i];
            var nextSlot = bookedSlotsArray[i + 1];

            var currentEndTime = new Date(currentSlot.ENDTIME);
            var nextStartTime = new Date(nextSlot.STARTTIME);

            // If there is a gap between the end of the current slot and the start of the next slot
            if (currentEndTime.getTime() < nextStartTime.getTime()) {
                nextAvailableStartTime = currentEndTime;
                break;
            }
        }

        // If no gaps found, taking the end time of the last slot
        if (!nextAvailableStartTime) {
            nextAvailableStartTime = new Date(bookedSlotsArray[bookedSlotsArray.length - 1].ENDTIME);
        }

        var startDateString = nextAvailableStartTime.getDate() + "/" + (nextAvailableStartTime.getMonth() + 1) + "/" + nextAvailableStartTime.getFullYear();
        var startTimeString = nextAvailableStartTime.getHours() + ":" + nextAvailableStartTime.getMinutes();

        startDateString = makeDateStringOrdered(startDateString);
        startTimeString = makeHourIsToMinsStringOrdered(startTimeString);
        startTimeString = startTimeString.replace(/\s+/g, '');

        document.getElementById('startDate').value = startDateString;
        document.getElementById('fromtime').value = startTimeString;

        if (isFirstLoad) {
            updateToDateWithFromDate();
        }
    }
}
function fixEndTimeForEndDateChange(){


    var selectedEndDate = parseStringToDateObj(document.getElementById('endDate').value);
    var selectedEndTimeStr = document.getElementById('totime').value;
    selectedEndTimeStr = makeHourIsToMinsStringOrdered(selectedEndTimeStr);
    selectedEndDate.setHours(getHourFromTime(selectedEndTimeStr));
    selectedEndDate.setMinutes(getMinsFromTime(selectedEndTimeStr));
    selectedEndDate.setSeconds(0);

    var selectStartDate = new Date(parseStringToDateObj(document.getElementById('startDate').value));
    var selectedStartTimeStr = makeHourIsToMinsStringOrdered(document.getElementById('fromtime').value);
    selectStartDate.setHours(getHourFromTime(selectedStartTimeStr));
    selectStartDate.setMinutes(getMinsFromTime(selectedStartTimeStr));
    selectStartDate.setSeconds(0);
    var confirmEndTime = getServerDate();

    if(selectedEndDate.getDate() == selectStartDate.getDate()){
        confirmEndTime.setHours(getHourFromTime(selectedStartTimeStr));
        confirmEndTime.setMinutes(getMinsFromTime(selectedStartTimeStr));
    }else {
        confirmEndTime.setHours(0);
        confirmEndTime.setMinutes(0);
    }
    confirmEndTime.setSeconds(0);
    var confirmEndTimeStr = confirmEndTime.getHours() + ":" + confirmEndTime.getMinutes();
    confirmEndTimeStr = makeHourIsToMinsStringOrdered(confirmEndTimeStr);
    //if end time is before start time
    if(selectedEndDate.getTime() < selectStartDate.getTime()){
        document.getElementById('totime').value = confirmEndTimeStr;
        return;
    }
    //handle for in between time slots
    var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;

    var needToUpdate = false;
    for (const key of Object.keys(bookedSlots)) {
        var bookedStartTime =bookedSlots[key].STARTTIME;
        var bookedEndTime =bookedSlots[key].ENDTIME;

        if ((selectStartDate < bookedEndTime && selectedEndDate > bookedStartTime) ||
            (selectStartDate <= bookedStartTime && selectedEndDate >= bookedEndTime)) {
            needToUpdate = true;
            break;
        }
    }
    var maximumRequestDay = getMaximumRequestDate();
    if(selectedEndDate.getTime() > maximumRequestDay.getTime()){
        needToUpdate = true;
    }
    //accessDurLimit
    var maximumAccessDuration = getMaximumAccessDurationDate();
    if(selectedEndDate.getTime() > maximumAccessDuration.getTime()){
        needToUpdate = true;
    }
    if(needToUpdate){
        document.getElementById('totime').value = makeHourIsToMinsStringOrdered(confirmEndTimeStr);
    }
}
function initializeAccessControlTimeline(){
//checking if all the data required for displaying timeslot are availble
if(!accessControlBookedSlotDetails.success){
    self.flashes.danger(I18N.getMsg("js.accessControl.Invalid.request"), 2000);
    closeDialog();
}
    var date = getServerDate();
    date = removeHrsMinsSecsFromDate(date);
    accessControlBookedSlotDetails.currentTimelineDate = date.getTime();
    hideToolBox();
    constructSlotTemplateToDom();
    jQuery('#overAllSlotTemplate').css('max-height', 'none');// NO I18N
    jQuery('#overAllSlotTemplate').css('position', 'relative');// NO I18N
    jQuery('#overAllSlotTemplate').perfectScrollbar({// NO I18N
        wheelSpeed : 1,
        includePadding : true,
        wheelPropagation : true
    });
    if(accessControlBookedSlotDetails != null){
        var passwordInuseTimeMap = accessControlBookedSlotDetails.requestLaterJSON.bookedSlotsMap;
        for (const key of Object.keys(passwordInuseTimeMap)) {
            var timeConf = passwordInuseTimeMap[key];
            timeConf.STARTTIME = convertToTimeZone(new Date(timeConf.STARTTIME),accessControlBookedSlotDetails.timeZone);
            timeConf.ENDTIME = convertToTimeZone(new Date(timeConf.ENDTIME),accessControlBookedSlotDetails.timeZone);
            passwordInuseTimeMap[key] = timeConf;
        }
        accessControlBookedSlotDetails.requestLaterJSON.bookedSlotsMap = passwordInuseTimeMap;
        accessControlBookedSlotDetails.serverDate = getServerDate();
        accessControlBookedSlotDetails.requestLaterJSON.mergedSlots = getMergeTimeSlots(accessControlBookedSlotDetails.requestLaterJSON.bookedSlotsMap)
    }
    initializeServerTimeClock();
    initializeCalendar();
    initializeTimePicker();
    scrollTimeLineAndBuildSelectedSlot();
}

/// Access Control Timeline UI methods ///

//This method constructs skeleton of timeline in the dom
function constructSlotTemplateToDom(){
    var hrHelper = 0;
    var hrs = "00";// NO I18N
    var mins = "00";// NO I18N
    //2hrs  divisions so 12 itration
    var numOfDivision = 14;
    var numOfDaysInTimeline = 3;
    for (var j = 1; j < numOfDivision; j++) {
        var formRow = document.createElement("div");// NO I18N
        formRow.className = "form-row";// NO I18N
        for (var i = 0; i <= numOfDaysInTimeline; i++) {
            var formEle = document.createElement("div");// NO I18N
            if (i === 0) {
                formEle.classList.add("form-ele-3","align-center");// NO I18N
                mins = "00";// NO I18N
                hrs = hrHelper;
                hrHelper = hrHelper +2;
                var time = hrs + ":" + mins;// NO I18N
                time = hrHelper == 2 ? "" : makeHourIsToMinsStringOrdered(time);//NO I18N
                formEle.replaceChildren(); // Removes all child nodes
                var label = document.createElement("label");// NO I18N
                label.textContent = time;
                formEle.appendChild(label);
            }else {
                formEle.classList.add("form-ele-3");// NO I18N
                formEle.setAttribute("id","time_cell_day_" + i + "_row_num_"+j);// NO I18N
            }
            formRow.appendChild(formEle);
        }
        document.getElementById('bookedSlotsContainer').appendChild(formRow);// NO I18N
    }
}
// this method filters booked slots which must be displayed now on the timeline
function getThreeDaysSlotsFromGivenDate(date,passwordInuseTimeMap){
    // change according to numOfDaysInHeading
    var ThreeDaysSlotsFromGivenDate = [[],[],[]];
    if (date != null && date instanceof Date) {
        //since we don't want to compare time in this method setting time to zero.
        date = removeHrsMinsSecsFromDate(date);
        var numOfDaysInHeading = 3;
        var numOfDaysDate = [];
        for (var i = 0; i < numOfDaysInHeading; i++) {
            var nextDate = new Date(date);
            nextDate.setDate(date.getDate() + i );
            numOfDaysDate.push(nextDate);
        }
        if(accessControlBookedSlotDetails != null){
            for (const key of Object.keys(passwordInuseTimeMap)) {
                var timeConf = passwordInuseTimeMap[key];
                const bookedStartTime = timeConf.STARTTIME;
                const bookedEndTime = timeConf.ENDTIME;
                const slotNumber = timeConf.SLOTNUMBER;

                for(var dayNum = 0; dayNum < numOfDaysDate.length; dayNum++){
                    var day = numOfDaysDate[dayNum];
                    var sameStartDate = false;
                    var sameEndDate = false;
                    var fullDayAccess = false;
                    var endDateOfCurrentIrrDay = new Date(day);
                    endDateOfCurrentIrrDay.setDate(endDateOfCurrentIrrDay.getDate() +1);
                    endDateOfCurrentIrrDay.setMinutes(endDateOfCurrentIrrDay.getMinutes() -1);
                    if((bookedStartTime.getTime() <= day.getTime()) && (bookedEndTime.getTime() >= endDateOfCurrentIrrDay.getTime())){
                        fullDayAccess = true;
                    }
                    if((day.getDate() === bookedStartTime.getDate() && day.getMonth() === bookedStartTime.getMonth() && day.getFullYear() === bookedStartTime.getFullYear()) ){
                        sameStartDate = true;
                    }
                    if((day.getDate() === bookedEndTime.getDate() && day.getMonth() === bookedEndTime.getMonth() && day.getFullYear() === bookedEndTime.getFullYear()) ){
                        sameEndDate = true;
                    }
                    if(sameStartDate || sameEndDate || fullDayAccess){
                        //UI Display
                        var slotStartTime = "00:00";// NO I18N
                        var slotEndTime = "00:00";// NO I18N
                        var slotDisplayStartDate = bookedStartTime.getDate() + "/" + (bookedStartTime.getMonth() + 1) + "/" + bookedStartTime.getFullYear();// NO I18N
                        var slotDisplayEndDate = bookedEndTime.getDate() + "/" + (bookedEndTime.getMonth() + 1) + "/" + bookedEndTime.getFullYear();// NO I18N

                        var startHour = bookedStartTime.getHours();
                        var startMin = bookedStartTime.getMinutes();
                        var endHour = bookedEndTime.getHours();
                        var endMin = bookedEndTime.getMinutes();
                        if(fullDayAccess){
                            startHour = "00";// NO I18N
                            startMin = "00";// NO I18N
                            endHour = "24";// NO I18N
                            endMin = "00";// NO I18N

                        }else if(sameStartDate && sameEndDate){
                            startHour = bookedStartTime.getHours();
                            startMin = bookedStartTime.getMinutes();
                            endHour = bookedEndTime.getHours();
                            endMin = bookedEndTime.getMinutes();
                            slotDisplayStartDate = "";
                            slotDisplayEndDate = "";
                        }else if(sameStartDate){
                            startHour = bookedStartTime.getHours();
                            startMin = bookedStartTime.getMinutes();
                            endHour = "24";// NO I18N
                            endMin = "00";// NO I18N
                        }else if(sameEndDate){
                            startHour = "00";// NO I18N
                            startMin = "00";// NO I18N
                            endHour = bookedEndTime.getHours();
                            endMin = bookedEndTime.getMinutes();
                        }
                        slotStartTime = startHour + ":" + startMin;// NO I18N
                        slotEndTime = endHour + ":" + endMin;// NO I18N

                        //Slot Data
                        var slotInterval = {
                            "STARTTIME" : slotStartTime,// NO I18N
                            "ENDTIME" : slotEndTime,// NO I18N
                            "SLOTNUMBER" : slotNumber// NO I18N
                        };
                        ThreeDaysSlotsFromGivenDate[dayNum].push(slotInterval);
                    }
                }
            }
        }
        return ThreeDaysSlotsFromGivenDate;
    }
}
/*slotNumber is like unique id for each slot
* even while switching dates in timeline
* also it helps in identifying slot like sameStartDate || sameEndDate || full day access in getThreeDaysSlotsFromGivenDate method
* */

// this method creates the booked slots in the timeline
function buildSlotBoxs(ThreeDaysSlotsFromGivenDate){
    //for setting height(duration) of the slot
    var allBookedSlotsDiv = document.getElementById('allBookedSlots');// NO I18N
    var timelineItems = document.getElementById('bookedSlotsContainer').getElementsByClassName('form-row');// NO I18N
    var timelineStart = getBookedSlotTimeInMins(timelineItems[2].textContent.trim());
    var oneTimeUnit = getBookedSlotTimeInMins(timelineItems[3].textContent.trim()) - getBookedSlotTimeInMins(timelineItems[2].textContent.trim());
    var slotHeight = timelineItems[1].offsetHeight;

    for (var dayNum = 0; dayNum < ThreeDaysSlotsFromGivenDate.length; dayNum ++){
        var eachDaySlots = ThreeDaysSlotsFromGivenDate[dayNum];
        var className = "day-" + (dayNum +1);// NO I18N
        var idOfDayTimeline = "day-" + (dayNum +1);// NO I18N
        for(var slotNum = 0; slotNum < eachDaySlots.length; slotNum++){
            var slot = eachDaySlots[slotNum];
            var startTime = slot.STARTTIME;
            var endTime = slot.ENDTIME;
            startTime = makeHourIsToMinsStringOrdered(startTime);
            endTime = makeHourIsToMinsStringOrdered(endTime);
            var timeInterval = slot.INTERVAL;
            var slotNumber = slot.SLOTNUMBER;
            const slotBox = document.createElement('div');// NO I18N
            slotBox.classList.add('slot-box', className);// NO I18N
            slotBox.setAttribute('start-time', startTime);// NO I18N
            slotBox.setAttribute('end-time', endTime);// NO I18N
            slotBox.setAttribute('slot-num', slotNumber);// NO I18N
            const spanElement = document.createElement('span');// NO I18N
            spanElement.classList.add('slot-box-tittle');// NO I18N
            spanElement.textContent = timeInterval;
            slotBox.onclick = (event) => { showToolBox(event, slotBox); };
            slotBox.onmouseover = (event) => {
                var ggg = event;
                timer = setTimeout(() => {
                    showToolBox(ggg, slotBox);
                }, 700);
            };
            slotBox.onmouseleave = (event) => {
                clearTimeout(timer);
                // hideToolBox();
            };

            //setting height
            var startTimeInMins = getBookedSlotTimeInMins(startTime);
            var endTimeInMins = getBookedSlotTimeInMins(endTime);
            var duration = endTimeInMins - startTimeInMins;
            var eventTop = 2*slotHeight + slotHeight*(startTimeInMins - timelineStart)/oneTimeUnit;
            var eventHeight = slotHeight*duration/oneTimeUnit;

            slotBox.setAttribute('style', 'top: '+(eventTop)+'px    ; height: '+(eventHeight)+'px');// NO I18N
            slotBox.appendChild(spanElement);

            if(allBookedSlotsDiv){
                var dayTimeline = allBookedSlotsDiv.querySelector(('#' + idOfDayTimeline));// NO I18N
                if(dayTimeline != null){
                    dayTimeline.appendChild(slotBox);
                }
            }
        }
    }
}
// clears on the booked slots in the timeline
function clearOldSlots(){
    var allBookedSlotsContainer = document.getElementById('allBookedSlots');// NO I18N
    var allDays = allBookedSlotsContainer.children;
    //will be changed to id specific
    for (var numOfDay = 0; numOfDay < allDays.length; numOfDay++){
        allDays[numOfDay].replaceChildren();
    }
}
function scrollTimeLineAndBuildSelectedSlot(){
    var selectedTime = getSelectedFromDate();
    var timelineItems = document.getElementById('bookedSlotsContainer').getElementsByClassName('form-row');// NO I18N
    var oneTimeUnit = getBookedSlotTimeInMins(timelineItems[3].textContent.trim()) - getBookedSlotTimeInMins(timelineItems[2].textContent.trim());
    var slotHeight = timelineItems[1].offsetHeight;
    var startDateTimeInIsToFormat = "00 : 00";//NO I18N
    var selectedTimeInIsFormat = selectedTime.getHours() + " : " + selectedTime.getMinutes();
    startDateTimeInIsToFormat = makeHourIsToMinsStringOrdered(startDateTimeInIsToFormat);
    selectedTimeInIsFormat = makeHourIsToMinsStringOrdered(selectedTimeInIsFormat);
    var startTimeInMins = getBookedSlotTimeInMins(startDateTimeInIsToFormat);
    var endTimeInMins = getBookedSlotTimeInMins(selectedTimeInIsFormat);
    var duration = endTimeInMins - startTimeInMins;
    var eventHeight = slotHeight*duration/oneTimeUnit;
    var element = document.getElementById('overAllSlotTemplate');
    eventHeight = eventHeight - 50;
    element.scrollTop = eventHeight;
    buildSelectedSlot();
}
function updateTimelineToSelectedDate(selectDateEle){
    var selectDateAsString = selectDateEle.value;
    var isFromDate = selectDateEle.id === 'startDate' ;
    var selectedDate = isFromDate ? getSelectedFromDate() : getSelectedEndDate();
    selectedDate.setSeconds(0);
    accessControlBookedSlotDetails.currentTimelineDate = selectedDate.getTime();
    hideToolBox();
    clearOldSlots();
    var timelineTime = getCurrentTimelineDateInTime();
    var timelineDate = convertTimeToDateObject(timelineTime);
    var passwordInuseTimeMap = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
    buildSlotBoxs(getThreeDaysSlotsFromGivenDate(timelineDate,passwordInuseTimeMap));

    syncDateHeadingWithTimelineDate(timelineDate);
    hideNextOrPrevButtonIfNextOrPrevDayNotExists();
    if(isFromDate){
        fixStartTimeForStartDateChange(selectedDate);
    }
    fixEndDateForStartChange(true);
    fixEndTimeForEndDateChange();
}
function updateToTimeInputToSelectedTime(startOrEndDateEle){
    var fromTime = document.getElementById('fromtime').value;// NO I18N
    document.getElementById('totime').value = fromTime;// NO I18N
}
// used while switching over dates in timeline (next or prev button)
function increaseOrDecreaseTimeLineDate(isIncrease){
    // date from 'currentTimelineDate' is hrs mins secs free date will be easy to compare dates
    var prevDateOfTimeLine = accessControlBookedSlotDetails.currentTimelineDate;
    var date = convertTimeToDateObject(prevDateOfTimeLine);
    date.setDate(date.getDate() + ((isIncrease) ? 1 : -1));
    date = removeHrsMinsSecsFromDate(date);
    accessControlBookedSlotDetails.currentTimelineDate = date.getTime();
}
//down shifts one day in timeline
function showPrevDaySlots(){
    showPrevOrNextDaySlots(false);
}
//up shifts one day in timeline
function showNextDaySlots(){
    showPrevOrNextDaySlots(true);
}
function showPrevOrNextDaySlots(isNextDay){
    if(checkForAllowingToSwitchTimeline(isNextDay)){
        hideToolBox();
        increaseOrDecreaseTimeLineDate(isNextDay);
        clearOldSlots();
        var timelineTime = getCurrentTimelineDateInTime();
        var timelineDate = convertTimeToDateObject(timelineTime);
        buildSlotBoxs(getThreeDaysSlotsFromGivenDate(timelineDate,accessControlBookedSlotDetails.requestLaterJSON.mergedSlots));
        syncDateHeadingWithTimelineDate(timelineDate);
        buildSelectedSlot();
    }
    hideNextOrPrevButtonIfNextOrPrevDayNotExists();
}
//updates the date in the timeline heading while the date in the timeline changes
function syncDateHeadingWithTimelineDate(currentTimelineDate){
    var allBookedSlotsContainer = document.getElementById('bookedSlotsContainer');// NO I18N
    var allDaysHeadings = allBookedSlotsContainer.querySelectorAll('div[id^="dayHeading-day-"]');// NO I18N
    for (var numOfDay = 0; numOfDay < allDaysHeadings.length; numOfDay++){
        var displayDateHeading = currentTimelineDate.getDate() + "/" + (currentTimelineDate.getMonth() + 1) + "/" + currentTimelineDate.getFullYear()
        displayDateHeading = makeDateStringOrdered(displayDateHeading);
        displayDateHeading = convertDateToReadableFormat(displayDateHeading);
        var label = document.createElement("label");
        label.textContent = displayDateHeading;
        allDaysHeadings[numOfDay].replaceChildren(label);
        currentTimelineDate.setDate(currentTimelineDate.getDate() +1);
    }
}
function convertDateToReadableFormat(inputDate) {
    var dateParts = inputDate.split('/');
    var day = dateParts[0];
    var month = dateParts[1];
    var year = dateParts[2];
    var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];//NO I18N
    var monthName = monthNames[parseInt(month) - 1];

    var convertedDate = day + " " + monthName + " " + year;

    return convertedDate;
}
// toggles disable or enable next/prev button if necessary
function hideNextOrPrevButtonIfNextOrPrevDayNotExists(){
    var dateForNext = getServerDate();
    var dateForPrev = getServerDate();
    var timelineDate = getServerDate();
    var timelineTime = getCurrentTimelineDateInTime();
    var timeSlotContainer = document.getElementById('accessControlTimeline');// NO I18N
    var nextDaySlotButton = timeSlotContainer.querySelector('#showNextDaySlotsButton');// NO I18N
    var prevDaySlotButton = timeSlotContainer.querySelector('#showPrevDaySlotsButton');// NO I18N
    var maxRequestingDate = getMaxRequestingDateOfAccessControl();
    //if maxRequestingDate from general settings is one we don't allow to access both next and prev button of timeline
    maxRequestingDate = (maxRequestingDate == 1) ? 0 : maxRequestingDate;

    timelineDate.setTime(timelineTime);
    dateForNext = removeHrsMinsSecsFromDate(dateForNext);
    dateForPrev = removeHrsMinsSecsFromDate(dateForPrev);

    //for next button
    timelineDate.setDate(timelineDate.getDate() + 1);
    dateForNext.setDate(dateForNext.getDate() + maxRequestingDate);
    var isNextButtonDisabled = (timelineDate.getTime() > dateForNext.getTime())
    nextDaySlotButton.disabled = isNextButtonDisabled;
    if(isNextButtonDisabled){
        nextDaySlotButton.onmouseout = function() {UnTip(this);};
        nextDaySlotButton.onmouseover = function() {Tip(I18N.getMsg('js.access.control.maximum.timeline.date.reached'), this, 'top');};// NO I18N
    }else {
        nextDaySlotButton.title = '';
        nextDaySlotButton.onmouseout = null;
        nextDaySlotButton.onmouseover = null;
    }

    //for prev button
    timelineDate.setDate(timelineDate.getDate() - 2);
    dateForPrev.setDate(dateForPrev.getDate() - 1);
    var isPrevButtonDisabled = (timelineDate.getTime() <= dateForPrev.getTime());
    prevDaySlotButton.disabled = isPrevButtonDisabled;
    if(isPrevButtonDisabled){
        prevDaySlotButton.onmouseout = function() {UnTip(this);};
        prevDaySlotButton.onmouseover = function() {Tip(I18N.getMsg('js.access.control.minimum.timeline.date.reached'), this, 'top');};// NO I18N
    }else {
        prevDaySlotButton.title = '';
        prevDaySlotButton.onmouseout = null;
        prevDaySlotButton.onmouseover = null;
    }
}
function checkForAllowingToSwitchTimeline(isForward){
    var currentTimelineDate = getCurrentTimelineDateInTime();
    var timelineDate = convertTimeToDateObject(currentTimelineDate);
    var date = getServerDate();
    date = removeHrsMinsSecsFromDate(date);
    if(isForward){
        //forward current date in timeline must not exceed maxRequestingDate which is from general settings
        var maxRequestingDate = getMaxRequestingDateOfAccessControl();
        date.setDate(date.getDate() + maxRequestingDate);
        //adding one day to the date since current timeline date will be one day delay(that will be incremented after this validation)
        timelineDate.setDate(timelineDate.getDate() +1);
        return timelineDate.getTime() <= date.getTime();
    }else {
        //if back timeline date must not be current date
        return timelineDate.getTime() > date.getTime();
    }
}

///  Toolbox methods   ///

function showToolBox(event, hoverSlotBox){
    var startTime = hoverSlotBox.getAttribute('start-time');// NO I18N
    var endTime = hoverSlotBox.getAttribute('end-time');// NO I18N
    var slotContent = makeHourIsToMinsStringOrdered(startTime) + " to " + makeHourIsToMinsStringOrdered(endTime);// NO I18N
    $("#myData").html(slotContent)// NO I18N
    var mouseXAxisPos = event.pageX;
    var mouseYAxisPos = event.pageY;
    var timeSlotContainer = document.getElementById("bookedSlotsContainer");// NO I18N
    var containerWidth = timeSlotContainer.clientWidth;
    var containerHeight = timeSlotContainer.clientHeight;
    var containerRect = timeSlotContainer.getBoundingClientRect();
    var scrollTop = timeSlotContainer.scrollTop;
    var adjustedTop = mouseYAxisPos - containerRect.top + scrollTop + 10;
    var adjustedLeft = mouseXAxisPos - containerRect.left + 10;
    if (adjustedTop + $("#myData").outerHeight() > containerHeight) {// NO I18N
        adjustedTop = containerHeight - $("#myData").outerHeight() - 10;// NO I18N
    }
    if (adjustedLeft + $("#myData").outerWidth() > containerWidth) {// NO I18N
        adjustedLeft = containerWidth - $("#myData").outerWidth() - 10;// NO I18N
    }
    $("#myData").css({// NO I18N
        "display": "block",// NO I18N
        "position": "absolute",// NO I18N
        "top": adjustedTop + "px",// NO I18N
        "left": adjustedLeft + "px"// NO I18N
    });
}
function hideToolBox(){
    $("#myData").css({// NO I18N
        "display": "none"// NO I18N
    });
}

/// Common methods related to Date and time ///

// this method gives the current timeline date in numeric value
// 'currentTimelineDate' input is a temp of current timeline date
function getCurrentTimelineDateInTime(){
    var timelineDate;
    if(accessControlBookedSlotDetails != null && accessControlBookedSlotDetails.currentTimelineDate != null && typeof accessControlBookedSlotDetails.currentTimelineDate === 'number'){
        timelineDate = new Date(accessControlBookedSlotDetails.currentTimelineDate);
    }else {
        timelineDate = getServerDate();
    }
    timelineDate =  removeHrsMinsSecsFromDate(timelineDate);
    return timelineDate.getTime();
}
function updateToDateWithFromDate(){
    var fromDate = document.getElementById('startDate').value;// NO I18N
    var fromTime = document.getElementById('fromtime').value;// NO I18N
    document.getElementById('endDate').value = fromDate;// NO I18N
    document.getElementById('totime').value = fromTime;// NO I18N
}
//this method makes end to start time if any conflict is there in selected slot
function updateToDateWithRespectiveToFromDateAndBookedTime() {

    var fromDate = getSelectedFromDate();
    var toDate = getSelectedEndDate();
    var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
    var needToUpdate = false;
    for (const key of Object.keys(bookedSlots)) {
        var bookedStartTime =bookedSlots[key].STARTTIME;
        var bookedEndTime =bookedSlots[key].ENDTIME;

        if ((fromDate < bookedEndTime && toDate > bookedStartTime) ||
            (fromDate <= bookedStartTime && toDate >= bookedEndTime)) {
            needToUpdate = true;
            break;
        }
    }
    var maximumRequestDay = getMaximumRequestDate();
    if(toDate.getTime() > maximumRequestDay.getTime()){
        needToUpdate = true;
    }
    //accessDurLimit
    var maximumAccessDuration = getMaximumAccessDurationDate();
    if(toDate.getTime() > maximumAccessDuration.getTime()){
        needToUpdate = true;
    }
    if(fromDate.getTime() > toDate.getTime()){
        needToUpdate = true;
    }
    if(needToUpdate){
        updateToDateWithFromDate();
    }
}
function fixStartTimeForStartDateChange(selectedDate){

    var startOfTheDay = new Date(selectedDate);
    startOfTheDay.setMinutes(0);
    startOfTheDay.setHours(0);
    startOfTheDay.setSeconds(0);
    var currentDate = getServerDate();
    var startTimeString = "00:00";
    var startTimeInputId = "fromtime";//NO I18N
    var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
    var isSelectedTimeOfDateIsAvailable = true;
    var isStartOfDateIsAvailable = true;
    var isOutOfRequestDate = false;
    for (const key of Object.keys(bookedSlots)) {
        var bookedSlot = bookedSlots[key];
        var startTime = bookedSlot.STARTTIME;
        var endTime = bookedSlot.ENDTIME;
        if(selectedDate.getTime() >= startTime.getTime() && selectedDate.getTime() <= endTime.getTime()){
            isSelectedTimeOfDateIsAvailable = false;
        }
        if(startOfTheDay.getTime() >= startTime.getTime() && startOfTheDay.getTime() <= endTime.getTime()){
            isStartOfDateIsAvailable = false;
        }
    }

    //access request limit
    var selectedStartDate = getSelectedFromDate();

    var maximumRequestDay = getMaximumRequestDate();
    if(selectedStartDate.getTime() > maximumRequestDay.getTime()){
        isOutOfRequestDate = true;
    }

    //if select start date and time is not available and start of the date is available making the time to start of the select date
    if((!isSelectedTimeOfDateIsAvailable || isOutOfRequestDate) && isStartOfDateIsAvailable){
        //if start of the time is past current time setAvailableStartTime();
        if(startOfTheDay.getTime() < currentDate.getTime()){
            setAvailableStartTime(false);
            return;
        }
        document.getElementById(startTimeInputId).value = makeHourIsToMinsStringOrdered(startTimeString);
        return;
    }
    if (!isSelectedTimeOfDateIsAvailable || isOutOfRequestDate) {
        const startOfDay = new Date(selectedDate.setHours(0, 0, 0, 0));
        const endOfDay = new Date(selectedDate.setHours(23, 59, 59, 999));

        // Get all booked slots within the selected day
        var bookedSlotsArray = Object.values(bookedSlots)
            .filter(slot => {
                const endTime = new Date(slot.ENDTIME);
                return endTime >= startOfDay && endTime <= endOfDay;
            });

        // Sort slots by start time
        bookedSlotsArray.sort((a, b) => new Date(a.STARTTIME) - new Date(b.STARTTIME));
        var nextAvailableStartTime = null;

        for (var i = 0; i < bookedSlotsArray.length - 1; i++) {
            var currentSlot = bookedSlotsArray[i];
            var nextSlot = bookedSlotsArray[i + 1];

            var currentEndTime = new Date(currentSlot.ENDTIME);
            var nextStartTime = new Date(nextSlot.STARTTIME);

            // Check for a gap between the end of the current slot and the start of the next slot
            if (currentEndTime.getTime() < nextStartTime.getTime()) {
                nextAvailableStartTime = currentEndTime;
                break;
            }
        }

        // If no gaps found, use the end time of the last slot for that day
        if (!nextAvailableStartTime) {
            nextAvailableStartTime = new Date(bookedSlotsArray[bookedSlotsArray.length - 1].ENDTIME);
        }

        // Format the selected start time
        var startTimeString = nextAvailableStartTime.getHours() + ":" + nextAvailableStartTime.getMinutes();
        startTimeString = makeHourIsToMinsStringOrdered(startTimeString);

        document.getElementById(startTimeInputId).value = startTimeString;
    }
}
function fixEndDateForStartChange(isDateChange){
    var fromDateString = document.getElementById('startDate').value; // NO I18N
    var fromTimeString = document.getElementById('fromtime').value; // NO I18N
    var toDateString = document.getElementById('endDate').value; // NO I18N
    var toTimeString = document.getElementById('totime').value; // NO I18N

    if(isDateChange){
        toTimeString = "00:00";
    }
    var fromDate = getSelectedFromDate();
    var toDate = parseStringToDateObj(toDateString);
    toDate.setHours(getHourFromTime(toTimeString));
    toDate.setMinutes(getMinsFromTime(toTimeString));
    toDate.setSeconds(0);

    var bookedSlots = accessControlBookedSlotDetails.requestLaterJSON.mergedSlots;
    var needToUpdate = false;

    for (const key of Object.keys(bookedSlots)) {
        var bookedStartTime =bookedSlots[key].STARTTIME;
        var bookedEndTime =bookedSlots[key].ENDTIME;

        if ((fromDate < bookedEndTime && toDate > bookedStartTime) ||
            (fromDate <= bookedStartTime && toDate >= bookedEndTime)) {
            needToUpdate = true;
            break;
        }
    }
    //access request limit
    var maximumRequestDay = getMaximumRequestDate();
    if(toDate.getTime() > maximumRequestDay.getTime()){
        needToUpdate = true;
    }
    //access Dur Limit
    var maximumAccessDuration = getMaximumAccessDurationDate();
    if(toDate.getTime() > maximumAccessDuration.getTime()){
        needToUpdate = true;
    }
    if(fromDate.getTime() > toDate.getTime()){
        needToUpdate = true;
    }
    if(needToUpdate){
        if(isDateChange){
            document.getElementById('endDate').value = fromDateString;// NO I18N
            // document.getElementById('totime').value = fromTimeString;// NO I18N
        }else {
            // update to time alone
            fixEndTimeForEndDateChange();
        }

    }
}
function getHourFromTime(time) {
    return getHoursOrMinsFromTime(time,true);
}
function getMinsFromTime(time) {
    return getHoursOrMinsFromTime(time,false);
}
function getHoursOrMinsFromTime(time,isHr){
    time = time.trim();
    time = time.replace(/ /g,'');
    var timeArray = time.split(':');
    var hrs = parseInt(timeArray[0]);
    var mins = parseInt(timeArray[1]);
    return isHr ? hrs : mins;
}
//convert hh:mm time to mins
function getBookedSlotTimeInMins(time) {
    time = time.trim();
    time = time.replace(/ /g,'');// NO I18N
    var timeArray = time.split(':');// NO I18N
    var timeStamp = parseInt(timeArray[0])*60 + parseInt(timeArray[1]);
    return timeStamp;
}
function makeHourIsToMinsStringOrdered(time) {
    time = time.trim();
    time = time.replace(/ /g,'');// NO I18N
    var timeArray = time.split(':');// NO I18N
    var hrs = parseInt(timeArray[0]);
    var mins = parseInt(timeArray[1]);
    var orderedTime = (Math.abs(hrs) < 10 ? ("0" + hrs) : hrs) + ":" + (Math.abs(mins) < 10 ? ("0" + mins) : mins);// NO I18N
    return orderedTime;
}
function makeDateStringOrdered(dateAsString) {
    var parts = dateAsString.split('/');// NO I18N
    var day = parts[0];
    var month = parts[1];
    var year = parts[2];
    day = day.padStart(2, '0');// NO I18N
    month = month.padStart(2, '0');// NO I18N
    var formattedDate = day + '/' + month + '/' + year;// NO I18N

    return formattedDate;
}
function removeHrsMinsSecsFromDate(date){
    if(date instanceof Date){
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        date.setMilliseconds(0);
    }
    return date;
}
function getMaxRequestingDateOfAccessControl(){
    return (accessControlBookedSlotDetails != null) ? accessControlBookedSlotDetails.accessDayLimit : 1;
}
function getMaximumRequestDate(){
    var maximumRequestDay = getServerDate();
    maximumRequestDay.setDate(maximumRequestDay.getDate() + accessControlBookedSlotDetails.accessDayLimit);
    return maximumRequestDay;
}
function getMaximumAccessDurationDate(){
    var maximumAccessDuration = getSelectedFromDate();
    maximumAccessDuration.setHours(maximumAccessDuration.getHours() + accessControlBookedSlotDetails.accessDurLimit);
    return maximumAccessDuration;
}
function getSelectedFromDate(){
    var selectedStartDate = parseStringToDateObj(document.getElementById('startDate').value);
    var selectFromTimeStr = makeHourIsToMinsStringOrdered(document.getElementById('fromtime').value);
    selectedStartDate.setHours(getHourFromTime(selectFromTimeStr));
    selectedStartDate.setMinutes(getMinsFromTime(selectFromTimeStr));
    selectedStartDate.setSeconds(0);
    return selectedStartDate;
}
function getSelectedEndDate(){
    var selectedEndDate = parseStringToDateObj(document.getElementById('endDate').value);
    var selectEndTimeStr = makeHourIsToMinsStringOrdered(document.getElementById('totime').value);
    selectedEndDate.setHours(getHourFromTime(selectEndTimeStr));
    selectedEndDate.setMinutes(getMinsFromTime(selectEndTimeStr));
    selectedEndDate.setSeconds(0);
    return selectedEndDate;
}
function convertTimeToDateObject(fullTime){
    var date = new Date(fullTime);
    return date;
}
function parseStringToDateObj(dateStr) {
    var parts = dateStr.split('/');// NO I18N
    var day = parseInt(parts[0], 10);
    var month = parseInt(parts[1], 10) - 1;
    var year = parseInt(parts[2], 10);
    var serverDate = getServerDate();
    var date = new Date(year, month, day, serverDate.getHours(), serverDate.getMinutes(), 0, 0);

    return date;
}
function showOneDisableOther(option)
{
    if(option == "reqtab1"){
        document.getElementById("reqtab2").className = "hide";
        document.getElementById("reqtab1").className = "hide";
        document.getElementById("accessControlTimeline").className = "hide";
        setNowAcessTimeToInput();
    }else {
        document.getElementById("reqtab2").className = "";
        document.getElementById("reqtab1").className = "hide";
        document.getElementById("accessControlTimeline").className = "";
        setAvailableStartTime(true);
    }
    scrollTimeLineAndBuildSelectedSlot();
}
function setNowAcessTimeToInput(){
    var currentTime = getServerDate();
    var startHrVsMins = currentTime.getHours() + ":" + currentTime.getMinutes();//NO I18N
    var startDateString = currentTime.getDate() + "/" + (currentTime.getMonth() + 1) + "/" + currentTime.getFullYear();//NO I18N
    startHrVsMins  = makeHourIsToMinsStringOrdered(startHrVsMins);
    startDateString = makeDateStringOrdered(startDateString);
    document.getElementById('fromtime').value = startHrVsMins;//NO I18N
    document.getElementById('startDate').value = startDateString;//NO I18N
    document.getElementById('totime').value = startHrVsMins;//NO I18N
    document.getElementById('endDate').value = startDateString;//NO I18N
}
App.AccessRequestDetailsComponent = MC.McDialogComponent.extend(App.PmpDialogComponent,App.PmpTableComponent,{
    closeDialog : "closeDialog",//NO I18N
    refreshView : "refreshView",//NO I18N
    init :function(){
        this._super();
        this.setLayout();
    },
    setLayout : function()
    {
    },
    didInsertElement : function(){
        var formModel=this.get("dialogModel");
        if(!formModel.success){
            get(this, 'flashes').danger(I18N.getMsg("js.accessControl.Invalid.request"),2000); //NO I18N
            this.sendAction("refreshView");
            this.sendAction("closeDialog");
            return;
        }
         document.querySelectorAll(".timeline-rhs").forEach(function (rhs) {//NO I18N
                 if (rhs.scrollHeight > 125) {
                     rhs.classList.add("collapsed");//NO I18N

                     const expandText = document.createElement("span");//NO I18N
                     expandText.innerText = "...More";//NO I18N
                     expandText.classList.add("expand-text");//NO I18N
                     rhs.appendChild(expandText);

                     expandText.addEventListener("click", function () {//NO I18N
                         rhs.classList.toggle("expanded");//NO I18N
                         expandText.innerText = rhs.classList.contains("expanded") ? "Less" : "...More";//NO I18N
                     });
                 }
             });
             setNiceScroll('#request-timeline',"10px",true,true);//NO I18N
    },
    actions : {

    }
});

App.PasswordRequestAdminActionComponent = MC.McDialogComponent.extend(App.PmpDialogComponent,App.PmpTableComponent,{
    showContentInChildDialog : "showContentInChildDialog",//NO I18N
    parentView : "refreshView",//NO I18N
    closeDialog : "closeDialog",//NO I18N
    init :function(){
        this._super();
        this.setLayout();
    },
    setLayout : function()
    {
        this.set("layoutName","components/password-request-process");//NO I18N
    },
    didInsertElement : function(){
    var detail=this.get("reqDetails");
        if(!detail.success){
            get(this, 'flashes').danger(I18N.getMsg("js.accessControl.Invalid.request"),2000); //NO I18N
            this.sendAction("parentView");
            this.sendAction("closeDialog");
        }
    },
    actions : {
        requestApprove : function()
        {
            var detail=this.get("reqDetails");
            var url=new Function("return "+detail.item1.methodName)();	//NO I18N
            var reason = document.getElementById('reasonByAdmin').value;//NO I18N
            var param = "&REASON="+encodeURIComponent(reason); //NO I18N
            var data = "pmpcp="+Get_Cookie('pmpcc')+param;//NO I18N

            if(reason.length > 2500)
            {
                showCustomMessage(I18N.getMsg('js.settings.rebrand.inputlimit'),document.getElementById('reasonByAdmin'));
                return;
            }
            this.sendRequest({type:'POST', url : url, data:data, onSuccessFunc : "OnSuccessFunc"});//NO I18N
        },
        requestReject : function()
        {
            var detail=this.get("reqDetails");
            var url=new Function("return "+detail.item2.methodName)();	//NO I18N
            var reason = document.getElementById('reasonByAdmin').value;//NO I18N
            var param = "&REASON="+encodeURIComponent(reason); //NO I18N
            var data = "pmpcp="+Get_Cookie('pmpcc')+param;//NO I18N

            if(reason.length > 2500)
            {
                showCustomMessage(I18N.getMsg('js.settings.rebrand.inputlimit'),document.getElementById('reasonByAdmin'));
                return;
            }
            this.sendRequest({type:'POST', url : url, data:data, onSuccessFunc : "OnSuccessFunc"});//NO I18N
        },
        updateRequest : function()
        {
            var dialogConfig = {};
            dialogConfig.title = I18N.getMsg("js.requestdetails");
            dialogConfig.layoutName = "components/password-request-process";  //No I18N
            dialogConfig.modal = true;
            dialogConfig.width = 1000;
            dialogConfig.appendTo = "#PassTrixMain_CT";  //No I18N
            this.sendAction("showContentInChildDialog",this.get("reqDetails"), dialogConfig);
            this.sendAction("closeDialog");
        },
        OnSuccessFunc : function(res)
        {
            var res = trim(res);
            res = JSON.parse(res);
            if(!res.success){
                get(this, 'flashes').danger(res.mes,2000); //NO I18N
            }else{
                this.sendAction("parentView");
            }
        }
    }
});

function disableOrEnableKMPCSS(isDisable) {
    //css of KMP are overrided in access control approval dialog
    var KMP_PMPDiv = document.getElementById('KMP_Settings');
    if(KMP_PMPDiv != null) {
        var linkElements = KMP_PMPDiv.getElementsByTagName('link');
        for (var i = 0; i < linkElements.length; i++) {
            if (linkElements[i].href.endsWith('.css')) {
                if (isDisable) {
                    linkElements[i].disabled = true;
                } else {
                    linkElements[i].disabled = false;
                }
            }
        }
    }
}

function getMergeTimeSlots(timeSlots) {
    //sort by STARTTIME
    const slotsArray = Object.values(timeSlots).sort((a, b) => a.STARTTIME - b.STARTTIME);
    const mergedSlots = [];
    slotsArray.forEach((currentSlot) => {
        const lastMergedSlot = mergedSlots[mergedSlots.length - 1];
        if (!lastMergedSlot) {
            // If mergedSlots is empty, add the first slot
            mergedSlots.push({ ...currentSlot });
        } else {
            const lastEndTime = lastMergedSlot.ENDTIME;
            const currentStartTime = currentSlot.STARTTIME;
            // Check if the current slot overlaps or is continuous with the last merged slot
            if (currentStartTime <= lastEndTime) {
                // Update the end time of the last merged slot
                lastMergedSlot.ENDTIME = new Date(Math.max(lastEndTime.getTime(), currentSlot.ENDTIME.getTime()));
            } else {
                // No overlap, add the current slot as a new merged slot
                mergedSlots.push({ ...currentSlot });
            }
        }
    });

    return mergedSlots;
}


function buildSelectedSlot(){
    var startTime = getSelectedFromDate();
    var endTime = getSelectedEndDate();
    var selectedSlot = {
        "STARTTIME" : startTime,// NO I18N
        "ENDTIME" : endTime,// NO I18N
        "SLOTNUMBER" : "-1"// NO I18N
    };
    var customSlots = {"-1":selectedSlot};
    var endUserRequestedStartTime = accessControlBookedSlotDetails.requestStartTime;
    var endUserRequestedEndTime = accessControlBookedSlotDetails.requestEndTime;
    if(endUserRequestedStartTime != null && endUserRequestedStartTime != undefined && endUserRequestedEndTime != null && endUserRequestedEndTime != undefined){
        var endUserRequestedTimeSlot = {
            "STARTTIME" : endUserRequestedStartTime,// NO I18N
            "ENDTIME" : endUserRequestedEndTime,// NO I18N
            "SLOTNUMBER" : "-2"// NO I18N
        };
        customSlots["-2"] = endUserRequestedTimeSlot;
    }
    var allBookedSlotsDiv = document.getElementById('allBookedSlots');// NO I18N
    allBookedSlotsDiv.querySelectorAll('[slot-num="-1"]').forEach(selectedSlotEle => selectedSlotEle.remove());
    allBookedSlotsDiv.querySelectorAll('[slot-num="-2"]').forEach(requestedSlotEle => requestedSlotEle.remove());

    buildSlotBoxs(getThreeDaysSlotsFromGivenDate(new Date(getCurrentTimelineDateInTime()),customSlots));
}

function getServerDate(){

    var serverDate = new Date();
    if (accessControlBookedSlotDetails != null && typeof accessControlBookedSlotDetails.serverTime == 'number') {
        var serverTime = accessControlBookedSlotDetails.serverTime;
        serverDate = new Date(serverTime);
        serverDate = convertToTimeZone(serverDate,accessControlBookedSlotDetails.timeZone);
        serverDate.setSeconds(0);
        serverDate.setMilliseconds(0);
    }
    return serverDate;
}
function convertToTimeZone(date, timeZone) {
    return new Date(date.toLocaleString('en-US', { timeZone }));//NO I18N
}
function setNiceScrollForTimeline() {
    var passwordRequestForm = document.getElementById('PasswordRequestId');//NO I18N
    var isAdminApproval = passwordRequestForm ? false : true;
    var id = isAdminApproval ? "passwordReqDialog" : "PasswordRequestId";//NO I18N
    passwordRequestForm = document.getElementById(id);
    if (passwordRequestForm) {
        var screenHeight = window.innerHeight; // Get the screen height
        var overAllContainer = document.getElementById('overAllSlotTemplate');//NO I18N
        if (screenHeight < 680) {
            //for small screen window size we set scroll for the entire from
            passwordRequestForm.style.overflowY = "auto";// NO I18N
            passwordRequestForm.style.maxHeight = ((screenHeight - 100)+ "px");//NO I18N
            overAllContainer.style.height = "491px";//NO I18N
            setNiceScroll('#'+id,"10px",true,true);//NO I18N//NO I18N
        }
        else {
            const accessControlTimelineEle = document.getElementById("accessControlTimeline");//NO I18N
            const heightFromTop = accessControlTimelineEle.getBoundingClientRect().top + window.scrollY;

            const ticketRow = document.getElementById("ticket-row");//NO I18N
            const saveRow = document.getElementById("save-row");//NO I18N

            const ticketRowHeight = ticketRow?.offsetHeight || 0;
            const saveRowHeight = saveRow?.offsetHeight || 0;

            const totalHeight = ticketRowHeight + saveRowHeight;
            var toleranceHeight = isAdminApproval ? 45 : 35;
            var timelineHeight = screenHeight - (heightFromTop + totalHeight) - toleranceHeight;


            if(timelineHeight >  491){
                timelineHeight = "491px"//NO I18N
            }else{
                timelineHeight = (timelineHeight + "px");//NO I18N
            }
            //To show 12hrs in the Timeline we have given 280px
            overAllContainer.style.overflowY = "auto";//NO I18N
            overAllContainer.style.height = timelineHeight;
            setNiceScroll('#overAllSlotTemplate',"10px",true,true);//NO I18N
        }
    }
}
function initializeServerTimeClock() {
    var serverTimeDisplay = document.getElementById('currentServerTime');
    if (!serverTimeDisplay) {
        return;
    }

    var serverTime = accessControlBookedSlotDetails.serverDate;
    updateServerTimeDisplay(serverTimeDisplay, serverTime);

    var intervalId = setInterval(function() {
        serverTimeDisplay = document.getElementById('currentServerTime');
        if (!serverTimeDisplay) {
            clearInterval(intervalId);
            return;
        }
        serverTime.setMinutes(serverTime.getMinutes() + 1);
        updateServerTimeDisplay(serverTimeDisplay, serverTime);
    }, 60000); // Update every 60 seconds
}

function updateServerTimeDisplay(element, time) {
    if (element) {
        element.innerHTML = time.toLocaleTimeString('en-GB', { hour: '2-digit', minute: '2-digit', hour12: false });// NO I18N
    }
}